clear

use saezdata, replace
drop if year==2009


* Total

ge yex9095=(yex90100*100-yex95100*50)/50
ge yex9599=(yex95100*100-yex99100*20)/80
ge yex99999=(yex99100*100-yex999100*10)/90
ge yex9999999=(yex999100*100-yex9999100*10)/90
ge yex099=yex0100-0.01*yex99100
for any 0100 090 9095 9599 99100 99999 9999999 9999100 099: ge gyexX=yexX/yexX[_n-1]-1
for any 0100 090 9095 9599 99100 99999 9999999 9999100 099: ge lngyexX=ln(yexX/yexX[_n-1])

for any 9095 9599 99999 9999999 9999100 099: ge ratioX=yexX/yex0100

* Wages

ge yw9095=(yw90100*100-yw95100*50)/50
ge yw9599=(yw95100*100-yw99100*20)/80
ge yw99999=(yw99100*100-yw999100*10)/90
ge yw9999999=(yw999100*100-yw9999100*10)/90
ge yw099=yw0100-0.01*yw99100

*ge fw090=yw090*0.90/yw0100
*ge fw9095=yw9095*0.05/yw0100
*ge fw9599=yw9599*0.04/yw0100
*ge fw99100=yw99100*0.01/yw0100

for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge gywX=ywX/ywX[_n-1]-1
for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge lngywX=ln(ywX/ywX[_n-1])

* Entrepreneurial

ge ye9095=(ye90100*100-ye95100*50)/50
ge ye9599=(ye95100*100-ye99100*20)/80
ge ye99999=(ye99100*100-ye999100*10)/90
ge ye9999999=(ye999100*100-ye9999100*10)/90
ge ye099=ye0100-0.01*ye99100

for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge gyeX=yeX/yeX[_n-1]-1
for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge lngyeX=ln(yeX/yeX[_n-1])

* Dividends

ge yd9095=(yd90100*100-yd95100*50)/50
ge yd9599=(yd95100*100-yd99100*20)/80
ge yd99999=(yd99100*100-yd999100*10)/90
ge yd9999999=(yd999100*100-yd9999100*10)/90
ge yd099=yd0100-0.01*yd99100

for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge gydX=ydX/ydX[_n-1]-1
for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge lngydX=ln(ydX/ydX[_n-1])

* Interest

ge yi9095=(yi90100*100-yi95100*50)/50
ge yi9599=(yi95100*100-yi99100*20)/80
ge yi99999=(yi99100*100-yi999100*10)/90
ge yi9999999=(yi999100*100-yi9999100*10)/90
ge yi099=yi0100-0.01*yi99100

for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge gyiX=yiX/yiX[_n-1]-1
for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge lngyiX=ln(yiX/yiX[_n-1])


* Rental

ge yr9095=(yr90100*100-yr95100*50)/50
ge yr9599=(yr95100*100-yr99100*20)/80
ge yr99999=(yr99100*100-yr999100*10)/90
ge yr9999999=(yr999100*100-yr9999100*10)/90
ge yr099=yr0100-0.01*yr99100

for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge gyrX=yrX/yrX[_n-1]-1
for any 0100 090 9095 9599 99100 99999 9999999 9999100: ge lngyrX=ln(yrX/yrX[_n-1])




* TABLE 1
* =======

ge psgyyex0100=psyex0100/psyex0100[_n-1]-1
ge lnpsgyyex0100=ln(1+psgyyex0100)

ge gyyex0100=gyex0100
replace gyyex0100=psgyyex0100 if gyyex0100==.
ge lngyyex0100=lngyex0100
replace lngyyex0100=lnpsgyyex0100 if lngyyex0100==.

for any 090 9095 9599 99100 99999 9999999 9999100: ge lngyyexX=lngyexX

tab year if gyyex0100<0
tab year if gyyex0100>=0 & gyyex0100~=.

ge rec=1 if year>=1918 & year<=1921
replace rec=2 if year==1924
replace rec=3 if year>=1930 & year<=1933
replace rec=4 if year>=1938 & year<=1938
replace rec=5 if year>=1945 & year<=1947
replace rec=6 if year>=1949 & year<=1949
replace rec=7 if year>=1954 & year<=1954
replace rec=8 if year>=1958 & year<=1958
replace rec=9 if year>=1974 & year<=1975
replace rec=10 if year>=1980 & year<=1980
replace rec=11 if year>=1982 & year<=1982
replace rec=12 if year>=1990 & year<=1991
* overrule 1993
replace rec=13 if year>=2001 & year<=2003
replace rec=14 if year>=2008 & year<=2008

ge boom=1 if year>=1922 & year<=1923
replace boom=2 if year>=1925 & year<=1929
replace boom=3 if year>=1934 & year<=1937
replace boom=4 if year>=1939 & year<=1944
replace boom=5 if year>=1948 & year<=1948
replace boom=6 if year>=1950 & year<=1953
replace boom=7 if year>=1955 & year<=1957
replace boom=8 if year>=1959 & year<=1973
replace boom=9 if year>=1976 & year<=1979
replace boom=10 if year>=1981 & year<=1981
replace boom=11 if year>=1983 & year<=1989
replace boom=12 if year>=1992 & year<=2000
replace boom=13 if year>=2004 & year<=2007

egen nrec=count(year), by(rec)
egen nboom=count(year), by(boom)

for any 0100 99100 99999 9999999 9999100: egen srecX=sum(lngyyexX), by(rec)
for any 0100 99100 99999 9999999 9999100: egen sboomX=sum(lngyyexX), by(boom)
for any 0100 99100 99999 9999999 9999100: ge ssrecX=100*(exp(srecX)^(1/nrec)-1)
for any 0100 99100 99999 9999999 9999100: ge ssboomX=100*(exp(sboomX)^(1/nboom)-1)
gsort -boom year
li year boom ssboom* if boom~=boom[_n-1] & boom~=., clean
gsort -rec year
li year rec ssrec* if rec~=rec[_n-1] & rec~=., clean
so year




* TABLE 2
* =======

* FIRST PANEL 
* -----------

eststo clear
eststo: reg lngyyex0100 lngyyex0100 if year>=1983
eststo:reg lngyyex99100 lngyyex0100 if year>=1983
eststo:reg lngyyex99999 lngyyex0100 if year>=1983
eststo:reg lngyyex9999999 lngyyex0100 if year>=1983
eststo:reg lngyyex9999100 lngyyex0100 if year>=1983
esttab, se nostar b(2)

eststo clear
eststo: reg lngyyex0100 lngyyex0100 if year>=1948 & year<=1982
eststo:reg lngyyex99100 lngyyex0100 if year>=1948 & year<=1982
eststo:reg lngyyex99999 lngyyex0100 if year>=1948 & year<=1982
eststo:reg lngyyex9999999 lngyyex0100 if year>=1948 & year<=1982
eststo:reg lngyyex9999100 lngyyex0100 if year>=1948 & year<=1982
esttab, se nostar b(2)

eststo clear
eststo: reg lngyyex0100 lngyyex0100 if year>=1918 & year<=1947
eststo:reg lngyyex99100 lngyyex0100 if year>=1918 & year<=1947
eststo:reg lngyyex99999 lngyyex0100 if year>=1918 & year<=1947
eststo:reg lngyyex9999999 lngyyex0100 if year>=1918 & year<=1947
eststo:reg lngyyex9999100 lngyyex0100 if year>=1918 & year<=1947
esttab, se nostar b(2)

* SECOND PANEL
* ------------

ge rryex99100=0.01*share99100/0.01
ge rryex99999=0.01*(share99100-share999100)/0.009
ge rryex9999999=0.01*(share999100-share9999100)/0.0009
ge rryex9999100=0.01*share9999100/0.0001
ge rryex0100=1
ge rryex90100=0.01*(share90100)/0.1
ge rryex9095=0.01*(share9095)/0.05
ge rryex9599=0.01*(share9599)/0.04
ge rryex090=0.01*(100-share90100)/0.9

su rryex0100 rryex99100 rryex99999 rryex9999999 rryex9999100 if year>=1982 & year<=2008
su rryex0100 rryex99100 rryex99999 rryex9999999 rryex9999100 if year>=1947 & year<=1982
su rryex0100 rryex99100 rryex99999 rryex9999999 rryex9999100 if year>=1917 & year<=1947

* THIRD PANEL
* -----------

for any 0100 99100 99999 9999999 9999100: ge dyexX=yexX-yexX[_n-1]
ge fd0100=dyex0100*(1)/yex0100[_n-1]
ge fd99100=dyex99100*(0.01)/yex0100[_n-1]
ge fd99999=dyex99999*(0.009)/yex0100[_n-1]
ge fd9999999=dyex9999999*(0.0009)/yex0100[_n-1]
ge fd9999100=dyex9999100*(0.0001)/yex0100[_n-1]

eststo clear
eststo: reg fd0100 gyex0100 if year>=1983
eststo: reg fd99100 gyex0100 if year>=1983
eststo: reg fd99999 gyex0100 if year>=1983
eststo: reg fd9999999 gyex0100 if year>=1983
eststo: reg fd9999100 gyex0100 if year>=1983
esttab, se nostar b(3) 

eststo clear
eststo: reg fd0100 gyex0100 if year>=1948 & year<=1982
eststo: reg fd99100 gyex0100 if year>=1948 & year<=1982
eststo: reg fd99999 gyex0100 if year>=1948 & year<=1982
eststo: reg fd9999999 gyex0100 if year>=1948 & year<=1982
eststo: reg fd9999100 gyex0100 if year>=1948 & year<=1982
esttab, se nostar b(3) 

* FOURTH PANEL
* ------------

ge lngypct50=ln(ypct50/ypct50[_n-1])
ge dur=ur-ur[_n-1]

eststo clear
eststo: reg lngyyex0100 lngypct50 if year>=1983 & year<=2008
eststo:reg lngyyex99100 lngypct50 if year>=1983 & year<=2008
eststo:reg lngyyex99999 lngypct50 if year>=1983 & year<=2008
eststo:reg lngyyex9999999 lngypct50 if year>=1983 & year<=2008
eststo:reg lngyyex9999100 lngypct50 if year>=1983 & year<=2008
esttab, se nostar b(2)

eststo clear
eststo: reg lngyyex0100 lngypct50 if year>=1968 & year<=1982
eststo:reg lngyyex99100 lngypct50 if year>=1968 & year<=1982
eststo:reg lngyyex99999 lngypct50 if year>=1968 & year<=1982
eststo:reg lngyyex9999999 lngypct50 if year>=1968 & year<=1982
eststo:reg lngyyex9999100 lngypct50 if year>=1968 & year<=1982
esttab, se nostar b(2)

eststo clear
eststo: reg lngyyex0100 dur if year>=1983 & year<=2008
eststo:reg lngyyex99100 dur if year>=1983& year<=2008
eststo:reg lngyyex99999 dur if year>=1983& year<=2008
eststo:reg lngyyex9999999 dur if year>=1983& year<=2008
eststo:reg lngyyex9999100 dur if year>=1983& year<=2008
esttab, se nostar b(3)
 
eststo clear
eststo: reg lngyyex0100 dur if year>=1948 & year<=1982
eststo:reg lngyyex99100 dur if year>=1948 & year<=1982
eststo:reg lngyyex99999 dur if year>=1948 & year<=1982
eststo:reg lngyyex9999999 dur if year>=1948 & year<=1982
eststo:reg lngyyex9999100 dur if year>=1948 & year<=1982
esttab, se nostar b(3)




* TABLE 3
* =======

* FIRST PANEL
* -----------

for any 0100 99100 99999 9999999 9999100: ge rywX=ywX/yexX
for any 0100 99100 99999 9999999 9999100: ge ryeX=yeX/yexX
for any 0100 99100 99999 9999999 9999100: ge rydX=ydX/yexX
for any 0100 99100 99999 9999999 9999100: ge ryiX=yiX/yexX
for any 0100 99100 99999 9999999 9999100: ge ryrX=yrX/yexX

for any w e d i r: tabstat ryX0100 ryX99100 ryX99999 ryX9999999 ryX9999100 if year>=1982 & year<=2008, stat(mean)
for any w e d i r: tabstat ryX0100 ryX99100 ryX99999 ryX9999999 ryX9999100 if year>=1947 & year<=1982, stat(mean)

* SECOND PANEL
* ------------

eststo clear
eststo: reg lngyex0100 lngyex0100 if year>=1983
eststo:reg lngyex99100 lngyex0100 if year>=1983
eststo:reg lngyex99999 lngyex0100 if year>=1983
eststo:reg lngyex9999999 lngyex0100 if year>=1983
eststo:reg lngyex9999100 lngyex0100 if year>=1983
esttab, se nostar b(2)

eststo clear
eststo: reg lngyw0100 lngyex0100 if year>=1983
eststo:reg lngyw99100 lngyex0100 if year>=1983
eststo:reg lngyw99999 lngyex0100 if year>=1983
eststo:reg lngyw9999999 lngyex0100 if year>=1983
eststo:reg lngyw9999100 lngyex0100 if year>=1983
esttab, se nostar b(2)

eststo clear
eststo: reg lngye0100 lngyex0100 if year>=1983
eststo:reg lngye99100 lngyex0100 if year>=1983
eststo:reg lngye99999 lngyex0100 if year>=1983
eststo:reg lngye9999999 lngyex0100 if year>=1983
eststo:reg lngye9999100 lngyex0100 if year>=1983
esttab, se nostar b(2)

eststo clear
eststo: reg lngyd0100 lngyex0100 if year>=1983
eststo:reg lngyd99100 lngyex0100 if year>=1983
eststo:reg lngyd99999 lngyex0100 if year>=1983
eststo:reg lngyd9999999 lngyex0100 if year>=1983
eststo:reg lngyd9999100 lngyex0100 if year>=1983
esttab, se nostar b(2)

eststo clear
eststo: reg lngyi0100 lngyex0100 if year>=1983
eststo:reg lngyi99100 lngyex0100 if year>=1983
eststo:reg lngyi99999 lngyex0100 if year>=1983
eststo:reg lngyi9999999 lngyex0100 if year>=1983
eststo:reg lngyi9999100 lngyex0100 if year>=1983
esttab, se nostar b(2)

eststo clear
eststo: reg lngyr0100 lngyex0100 if year>=1983
eststo:reg lngyr99100 lngyex0100 if year>=1983
eststo:reg lngyr99999 lngyex0100 if year>=1983
eststo:reg lngyr9999999 lngyex0100 if year>=1983
eststo:reg lngyr9999100 lngyex0100 if year>=1983
esttab, se nostar b(2)


eststo clear
eststo: reg lngyex0100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyex99100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyex99999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyex9999999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyex9999100 lngyex0100 if year>=1948 & year<=1982
esttab, se nostar b(2)

eststo clear
eststo: reg lngyw0100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyw99100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyw99999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyw9999999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyw9999100 lngyex0100 if year>=1948 & year<=1982
esttab, se nostar b(2)

eststo clear
eststo: reg lngye0100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngye99100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngye99999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngye9999999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngye9999100 lngyex0100 if year>=1948 & year<=1982
esttab, se nostar b(2)

eststo clear
eststo: reg lngyd0100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyd99100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyd99999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyd9999999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyd9999100 lngyex0100 if year>=1948 & year<=1982
esttab, se nostar b(2)

eststo clear
eststo: reg lngyi0100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyi99100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyi99999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyi9999999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyi9999100 lngyex0100 if year>=1948 & year<=1982
esttab, se nostar b(2)

eststo clear
eststo: reg lngyr0100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyr99100 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyr99999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyr9999999 lngyex0100 if year>=1948 & year<=1982
eststo:reg lngyr9999100 lngyex0100 if year>=1948 & year<=1982
esttab, se nostar b(2)




* FIGURE 2
* ========

ge sh0100ps=yex0100*(1)/psyex0100
ge sh99100ps=yex99100*(0.01)/psyex0100
ge sh99999ps=yex99999*(0.009)/psyex0100
ge sh9999999ps=yex9999999*(0.0009)/psyex0100
ge sh9999100ps=yex9999100*(0.0001)/psyex0100
label variable sh99100ps "99-100"
label variable sh99999ps "99-99.9"
label variable sh9999999ps "99.9-99.99"
label variable sh9999100ps "99.99-100"
label variable year " "

*edit year sh99100ps sh99999ps sh9999999ps sh9999100ps

scatter sh99100ps sh99999ps sh9999999ps sh9999100ps year if year>=1917, saving(figshare1.gph, replace) c(l l l l) symbol(d t o x) xla(1910(10)2010)




* FIGURE 3
* ========

for any 090 9095 9599 99100 99999 9999999 9999100: ge fullbetaX=.
for any 090 9095 9599 99100 99999 9999999 9999100: ge fullseX=.
for any 090 9095 9599 99100 99999 9999999 9999100: ge wfullbetaX=.
for any 090 9095 9599 99100 99999 9999999 9999100: ge wfullseX=.

reg lngyw090 lngyex0100  if year>=1983
replace wfullbeta090=_b[lngyex0100] if year>=1983
replace wfullse090=_b[lngyex0100] if year>=1983

reg lngyw9095 lngyex0100  if year>=1983
replace wfullbeta9095=_b[lngyex0100] if year>=1983
replace wfullse9095=_b[lngyex0100] if year>=1983

reg lngyw9599 lngyex0100  if year>=1983
replace wfullbeta9599=_b[lngyex0100] if year>=1983
replace wfullse9599=_b[lngyex0100] if year>=1983

reg lngyw99100 lngyex0100  if year>=1983
replace wfullbeta99100=_b[lngyex0100] if year>=1983
replace wfullse99100=_b[lngyex0100] if year>=1983

reg lngyw99999 lngyex0100  if year>=1983
replace wfullbeta99999=_b[lngyex0100] if year>=1983
replace wfullse99999=_b[lngyex0100] if year>=1983

reg lngyw9999999 lngyex0100  if year>=1983
replace wfullbeta9999999=_b[lngyex0100] if year>=1983
replace wfullse9999999=_b[lngyex0100] if year>=1983

reg lngyw9999100 lngyex0100  if year>=1983
replace wfullbeta9999100=_b[lngyex0100] if year>=1983
replace wfullse9999100=_b[lngyex0100] if year>=1983


reg lngyex090 lngyex0100  if year>=1983
replace fullbeta090=_b[lngyex0100] if year>=1983
replace fullse090=_b[lngyex0100] if year>=1983

reg lngyex9095 lngyex0100  if year>=1983
replace fullbeta9095=_b[lngyex0100] if year>=1983
replace fullse9095=_b[lngyex0100] if year>=1983

reg lngyex9599 lngyex0100  if year>=1983
replace fullbeta9599=_b[lngyex0100] if year>=1983
replace fullse9599=_b[lngyex0100] if year>=1983

reg lngyex99100 lngyex0100  if year>=1983
replace fullbeta99100=_b[lngyex0100] if year>=1983
replace fullse99100=_b[lngyex0100] if year>=1983

reg lngyex99999 lngyex0100  if year>=1983
replace fullbeta99999=_b[lngyex0100] if year>=1983
replace fullse99999=_b[lngyex0100] if year>=1983

reg lngyex9999999 lngyex0100  if year>=1983
replace fullbeta9999999=_b[lngyex0100] if year>=1983
replace fullse9999999=_b[lngyex0100] if year>=1983

reg lngyex9999100 lngyex0100  if year>=1983
replace fullbeta9999100=_b[lngyex0100] if year>=1983
replace fullse9999100=_b[lngyex0100] if year>=1983

for any 0100 090 9095 9599 99100 99999 9999999 9999100: egen fullmwratioto0100X=mean(ln(ywX[_n-1]/yw0100[_n-1])) if year>=1983
for any 0100 090 9095 9599 99100 99999 9999999 9999100: egen fullmyratioto0100X=mean(ln(rryexX[_n-1])) if year>=1983

ge fullbeta=fullbeta090          if year==1989
replace fullbeta=fullbeta9095    if year==1990
replace fullbeta=fullbeta9599    if year==1991
replace fullbeta=fullbeta99999   if year==1992
replace fullbeta=fullbeta9999999 if year==1993
replace fullbeta=fullbeta9999100 if year==1994

ge wfullbeta=wfullbeta090          if year==1989
replace wfullbeta=wfullbeta9095    if year==1990
replace wfullbeta=wfullbeta9599    if year==1991
replace wfullbeta=wfullbeta99999   if year==1992
replace wfullbeta=wfullbeta9999999 if year==1993
replace wfullbeta=wfullbeta9999100 if year==1994

ge fullmyratioto0100=fullmyratioto0100090          if year==1989
replace fullmyratioto0100=fullmyratioto01009095    if year==1990
replace fullmyratioto0100=fullmyratioto01009599    if year==1991
replace fullmyratioto0100=fullmyratioto010099999   if year==1992
replace fullmyratioto0100=fullmyratioto01009999999 if year==1993
replace fullmyratioto0100=fullmyratioto01009999100 if year==1994

ge fullmwratioto0100=fullmwratioto0100090          if year==1989
replace fullmwratioto0100=fullmwratioto01009095    if year==1990
replace fullmwratioto0100=fullmwratioto01009599    if year==1991
replace fullmwratioto0100=fullmwratioto010099999   if year==1992
replace fullmwratioto0100=fullmwratioto01009999999 if year==1993
replace fullmwratioto0100=fullmwratioto01009999100 if year==1994

label variable fullbeta "Beta of income"
label variable wfullbeta "Beta of wages

ge mlnr=(fullmyratioto0100)
ge mlnrw=(fullmwratioto0100)
label variable mlnr "Avg. ln(income ratio)"
label variable mlnrw "Avg. ln(wage ratio)"

ge group=1 if year==1989
replace group=2 if year==1990
replace group=3 if year==1991
replace group=4 if year==1992
replace group=5 if year==1993
replace group=6 if year==1994
label variable group "Group"
label define glab 1 "0-90" 2 "90-95" 3 "95-99" 4 "99-99.9" 5 "99.9-99.99" 6 "99.99-100"
label values group glab

*edit group fullbeta mlnr if fullbeta~=.
scatter fullbeta mlnr, mlabel(group) c(l) ylabel(0(1)4) xlabel(-1(1)6)  mlabpos(6)

*edit group wfullbeta mlnrw if wfullbeta~=.
scatter wfullbeta mlnrw, mlabel(group) c(l) ylabel(0(1)8) xlabel(-1(1)6)  mlabpos(6)




* FIGURE 4
* ========

* TOP GRAPH
* ---------

ge dec=int(year/10)

for any 99999 9999999 9999100: ge betaX=.

foreach num of numlist 197/200  {	
	reg lngyex99999 lngyex0100  if dec==`num'
	replace beta99999=_b[lngyex0100] if dec==`num'

	reg lngyex9999999 lngyex0100  if dec==`num'
	replace beta9999999=_b[lngyex0100] if dec==`num'

	reg lngyex9999100 lngyex0100  if dec==`num'
	replace beta9999100=_b[lngyex0100] if dec==`num'
}

for any 99999 9999999 9999100: egen myratioto0100X=mean(ln(rryexX[_n-1])), by(dec)
for any 99999 9999999 9999100: label variable betaX "Beta"
for any 99999 9999999 9999100: label variable myratioto0100X "Avg. ln(income ratio)"

ge b1=beta99999       		if year==1971 | year==1981 | year==1991 | year==2001
ge b2=beta9999999 		if year==1972 | year==1982 | year==1992 | year==2002
ge b3=beta9999100 		if year==1973 | year==1983 | year==1993 | year==2003

ge r=myratioto010099999        	if year==1971 | year==1981 | year==1991 | year==2001
replace r=myratioto01009999999 	if year==1972 | year==1982 | year==1992 | year==2002
replace r=myratioto01009999100 	if year==1973 | year==1983 | year==1993 | year==2003

label variable b1 "99-99.9"
label variable b2 "99.9-99.99"
label variable b3 "99.99-100"
label variable r "Avg. ln(income ratio)"

label define dlab 197 "1970s" 198 "1980s" 199 "1990s" 200 "2000s"
label values dec dlab
label variable dec "Decade"

*edit year b1 r if b1~=.
*edit year b2 r if b2~=.
*edit year b3 r if b3~=.

scatter b1 b2 b3 r, c(l l l) mlabel(dec dec dec) symbol(d t o) l1("Beta") ylabel(0(1)4)  xlabel(1(1)6) mlabpos(9 9 9)
drop b1-r


* BOTTOM GRAPH
* ------------

for any 99999 9999999 9999100: ge wbetaX=.

foreach num of numlist 197/200  {	
	reg lngyw99999 lngyex0100  if dec==`num'
	replace wbeta99999=_b[lngyex0100] if dec==`num'

	reg lngyw9999999 lngyex0100  if dec==`num'
	replace wbeta9999999=_b[lngyex0100] if dec==`num'

	reg lngyw9999100 lngyex0100  if dec==`num'
	replace wbeta9999100=_b[lngyex0100] if dec==`num'
}

for any 99999 9999999 9999100: egen mwratioto0100X=mean(ln(ywX[_n-1]/yw0100[_n-1])), by(dec)
for any 99999 9999999 9999100: label variable wbetaX "Beta"
for any 99999 9999999 9999100: label variable mwratioto0100X "Avg. ln(wage) ratio)"

ge b1=wbeta99999        if year==1971 | year==1981 | year==1991 | year==2001
ge b2=wbeta9999999 if year==1972 | year==1982 | year==1992 | year==2002
ge b3=wbeta9999100 if year==1973 | year==1983 | year==1993 | year==2003

ge r=mwratioto010099999        if year==1971 | year==1981 | year==1991 | year==2001
replace r=mwratioto01009999999 if year==1972 | year==1982 | year==1992 | year==2002
replace r=mwratioto01009999100 if year==1973 | year==1983 | year==1993 | year==2003

label variable b1 "99-99.9"
label variable b2 "99.9-99.99"
label variable b3 "99.99-100"
label variable r "Avg. ln(wage ratio)"

*edit year b1 r if b1~=.
*edit year b2 r if b2~=.
*edit year b3 r if b3~=.

scatter  b1 b2 b3 r, c(l l l) mlabel(dec dec dec) symbol(d t o) l1("Beta") saving(figwall, replace) ylabel(0(1)8) xlabel(1(1)6)  mlabpos(9 9 9)

save data, replace


* REGRESSION VERSIONS OF FIGURE 3, 4
* ==================================

keep year yex* yw*  rr*
rename yex090 yex90
rename yw090 yw90
rename yex0100 yex100
rename yw0100 yw100
rename rryex0100 rryex100
rename rryex090 rryex90

keep *100* *90* *9095* *9599* *99100* *99999* *9999999* *9999100* year rr*
keep if year>=1969 & year<=2008
reshape long yex yw rryex, i(year) j(group)

so group year
ge lngyw=ln(yw/yw[_n-1]) if group==group[_n-1]
ge lngyex=ln(yex/yex[_n-1]) if group==group[_n-1]

ge lngyex0100=lngyex if group==100
ge yex0100=yex if group==100
egen mlngyex0100=max(lngyex0100), by(year)
egen myex0100=max(yex0100), by(year)

ge lngyw0100=lngyw if group==100
ge yw0100=yw if group==100
egen mlngyw0100=max(lngyw0100), by(year)
egen myw0100=max(yw0100), by(year)

drop if inlist(group,100,90100,95100,99100,995100,999100)==1

ge r=ln(rryex[_n-1])
egen groupmeanr83=mean(r) if year>=1983, by(group)
ge mlngyex0100rr=mlngyex0100*(r)
ge mlngyex0100r83=mlngyex0100*(groupmeanr83)

ge rw=ln(yw[_n-1]/myw0100[_n-1]) if group==group[_n-1]
egen groupmeanrw83=mean(rw) if year>=1983, by(group)
ge mlngyw0100rrw=mlngyw0100*(rw)
ge mlngyw0100rw83=mlngyw0100*(groupmeanrw83)

* Regression version of Figure 3
xi: reg lngyex mlngyex0100 mlngyex0100r83  i.group if year>=1983
xi: reg lngyw mlngyw0100 mlngyw0100rw83  i.group if year>=1983

* Regression version of Figure 4
reg lngyex mlngyex0100 mlngyex0100rr r if group==99999
reg lngyex mlngyex0100 mlngyex0100rr r if group==9999999
reg lngyex mlngyex0100 mlngyex0100rr r if group==9999100
reg lngyw mlngyw0100 mlngyw0100rrw rw if group==99999
reg lngyw mlngyw0100 mlngyw0100rrw rw if group==9999999
reg lngyw mlngyw0100 mlngyw0100rrw rw if group==9999100



